/** GUI register **/

function showRegisterWindow(windowId, from) {
	console.log("showRegisterWindow: " + windowId);
	switch (windowId) {
		case "dialog-register-1":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-1").show();
			$("#dialog-register").dialog("widget").animate({
				width: '300px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-1").attr("title"));
			clearInterval(window.typewriter);
			break;
		case "dialog-register-2":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-2").fadeIn(1500); //show();
			$("#dialog-register").dialog("widget").animate({
				width: '480px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'top+15%')
				}
			}); // center')}});
			$("#info1").writeText(window.registerString.info1, function() {
				$("#register-submit-2").fadeIn(500);
				clearInterval(window.typewriter);
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-2").attr("title"));
			break;
		case "dialog-register-3":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-3").show();
			$("#dialog-register").dialog("widget").animate({
				width: '480px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-3").attr("title"));
			break;
		case "dialog-register-4":
		case "dialog-register-4-1":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-4").show();
			$("#dialog-register").dialog("widget").animate({
				width: '430px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-4").attr("title"));
			break;
		case "dialog-register-5":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-5").show();
			$("#dialog-register").dialog("widget").animate({
				width: '640px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			}); // 590
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-5").attr("title"));
			$("#dialog-register-5 .users-summary").html(getUsersSummary());
			break;
		case "dialog-register-6":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-6").show();
			$("#dialog-register").dialog("widget").animate({
				width: '480px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'top+15%')
				}
			}); // center
			$("#infoEnd").writeText(window.registerString.infoEnd, function() {
				$("#register-submit-6").fadeIn(500);
				clearInterval(window.typewriter);
			});
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-6").attr("title"));
			break;
		case "dialog-register-7":
			$('div[id^="dialog-register-"]').hide();
			$("#dialog-register-7").show();
			$("#dialog-register").dialog("widget").animate({
				width: '500px'
			}, {
				duration: 500,
				step: function() {
					$("#dialog-register").dialog('option', 'position', 'center')
				}
			});
			//$("#infoEnd").writeText(window.registerString.infoEnd, function() { $("#register-submit-7").fadeIn(500); clearInterval(window.typewriter); });
			$("#dialog-register").dialog('option', 'title', $("#dialog-register-7").attr("title"));
			break;
		default: //showing user add step
			if (windowId != undefined && windowId.substr(0, 17) != "dialog-register-4" && windowId.substr(0, 25) != "dialog-register-summary-4")
				break;

			var userWindowId = $("#" + windowId).attr('userWindowId');

			//showing summary window
			if ($("#" + windowId).attr('isSummaryWindow') != undefined) {
				console.log($("#" + windowId));
				$('div[id^="dialog-register-"]').hide();
				var summaryHtml = '<div class="row" style="text-align:center"><b>Informacja</b></div>\n\
							<div class="row" class="users-summary" style="padding: 10px; margin: 5px; background-color: #FFFFFF; border: 1px solid #333333; text-align: justify;">' + getUsersSummary(userWindowId) + '\
							</div>';
				$("#dialog-register-summary-4-" + userWindowId + " .register-form-left").html(summaryHtml);
				$("#dialog-register-summary-4-" + userWindowId).show();
				$("#dialog-register").dialog("widget").animate({
					width: '540px'
				}, {
					duration: 500,
					step: function() {
						$("#dialog-register").dialog('option', 'position', 'center')
					}
				});
				$("#dialog-register").dialog('option', 'title', $("#dialog-register-4-" + (userWindowId)).attr("title"));
			} else //showing form window
			{
				$('div[id^="dialog-register-"]').hide();
				$("#register-submit-summary-4-" + (userWindowId - 1)).hide();
				$("#register-submit-summary-4-" + (userWindowId - 1) + "-b").show();
				$("#dialog-register-4-" + userWindowId).show();
				$("#dialog-register").dialog("widget").animate({
					width: '500px'
				}, {
					duration: 500,
					step: function() {
						$("#dialog-register").dialog('option', 'position', 'center')
					}
				});
				$("#dialog-register").dialog('option', 'title', $("#dialog-register-4-" + (userWindowId)).attr("title"));
			}
			break;
	}
}

function activateRegister() {
	/**
	 * Dialog definitions
	 **/
	$("#dialog-register").dialog({
		autoOpen: false,
		hide: {
			effect: 'fold',
			duration: 500
		}, // clip
		show: {
			effect: 'fold',
			duration: 600
		}, // scale
		position: {
			my: "center",
			at: "center",
			of: window
		},
		closeOnEscape: false,
		draggable: false,
		resizable: false,
		width: 300
	});
	$("#dialog-register").parent().children(".ui-widget-header").children(".ui-dialog-titlebar-close").css("display", "none");
	$("#dialog-register").dialog('option', 'title', $("#dialog-register-1").attr("title"));
	$('[id^="dialog-register"][id!="dialog-register-1"]').css("display", "none");
	//$("#dialog-register-2, #dialog-register-3, #dialog-register-4, #dialog-register-4-2, #dialog-register-4-3, #dialog-register-4-4, #dialog-register-4-5, #dialog-register-4-6, #dialog-register-5, #dialog-register-6, #dialog-register-7").css("display", "none");
	//dialog-register-summary
	$("#register-submit-2, #register-submit-6").css("display", "none");

	/**
	 * Events
	 **/
	$("#dialog-register input").on("focus", function() {
		$("#dialog-register input").css("background-color", "#FFFFFF");
	});

	//next button handler
	$('[id^="register-submit"]').button().click(function() {
		if ($(this).is('[id^="register-submit-4"],[id^="register-submit-summary-4"]') || $(this).is('[id^="register-submit-5"]')) //we handle 4-* dialogs after ajax validation
			return false;
		if ($(this).attr('id') == 'register-submit')
			showRegisterWindow($(this).attr("target"), 'dialog-register-1');
		else
			showRegisterWindow($(this).attr("target"));
	});

	$("#register-submit-6").button().click(function() {
		console.log("#register-submit-6 click");
		$("#dialog-register-6").hide();
		window.location.hash = "";
	});

	//back button handler
	$('form').on('click', '[id^="register-back"][id!="register-back-5"]', function() {
		$('.tipsy').remove();
		showRegisterWindow($(this).attr("target"));
	});

	$('[id^="register-back"]').button();

	$('#register-back-1,#register-submit-7').button().click(function() {
		$('.tipsy').remove();
		window.location.hash = "";
	});

	$('#register-back-5').button().click(function() {
		showRegisterWindow('dialog-register-4-' + getLastUserView());
	});

	$("#UserRegistrationForm_city").change(function() {
		loadSchools($(this).val());
	});

	$("document").ready(function() {
		loadSchools($("#UserRegistrationForm_city").val());
	});

	$('#UserRegistrationForm_school').change(function() {
		loadClasses($(this).val());
	});

	$('[id^="register-submit-4"],[id^="register-submit-summary-4"],#register-submit-5,.register-submit-4').button().click(function() {
		var target = $(this).attr("target");
		var address = $('form#register-form').serialize();
		var validateFormId = $('[id^="dialog-register-4"]:visible').attr("userWindowId");

		//hide error messages
		$(".tipsy").fadeOut(400, function() {
			$(".tipsy").remove();
		});

		//validating single user form
		if (validateFormId > 0)
			address += '&validateFormId=' + validateFormId;

		if ($(this).hasClass('registerFinishButton') && !$('[name="users-check"]').is(':checked'))
			return false;
		if ($(this).hasClass('registerFinishButton'))
			address += '&register=true';

		$.post(window.ajaxRegisterFormUrl, address,
			function(data) {
				var resultErrors = jQuery.parseJSON(data);

				if (hasErrors(resultErrors)) {
					console.log(resultErrors);
					//has errors with class - time is out =
					if (!(resultErrors[0] instanceof Array)) {
						showRegisterWindow('dialog-register-7');
					} else {
						$('#dialog-register').find('.errorMessage').remove();
						displayErrors(resultErrors);
					}
				} else {
					console.log(resultErrors);
					showRegisterWindow(target);
				}
			});
	});
}

function getCurrentUserFormId() {
	var userFormId = $('[id^="dialog-register-4"]:visible').attr("id");
	if (!userFormId)
		return 0;
	userFormId = userFormId.length == 0 ? '1' : userFormId;
	return userFormId;
}

function hasErrors(errors) {
	for (var i = 0; i < errors.length - 1; i++)
		if (errors[i].length != 0)
			return true;
	return false;
}

function displayErrors(errors) {
	var firstUserError = 0;
	for (var i = 0; i <= window.numberOfMaxUsers; i++) {
		if (errors[i].length === 0)
			continue;
		else if (firstUserError == 0)
			firstUserError = i;

		for (var attribute in errors[i]) {
			var currentInput = $('[name="Uzytkownik[' + i + '][' + attribute + ']"]:last');
			/**************************/
			if (currentInput.next('.errorMessage').length == 0) //error message div not exists
			{
				//	currentInput.parent().append('<div id="Uzytkownik_'+i+'_'+attribute+'_em_" class="errorMessage"></div>');
			}

			var tipsyGravity = 'w';

			if ($('#Uzytkownik_' + i + '_' + attribute).attr('type') == 'radio' || $('#Uzytkownik_' + i + '_' + attribute).attr('type') == 'checkbox')
				tipsyGravity = 'e';

			$('#Uzytkownik_' + i + '_' + attribute).attr('title', errors[i][attribute][0]);
			$('#Uzytkownik_' + i + '_' + attribute).tipsy({
				trigger: 'manual',
				gravity: tipsyGravity,
				fade: true
			});
			$('#Uzytkownik_' + i + '_' + attribute).tipsy("show");

			//$('#Uzytkownik_'+i+'_'+attribute).addClass('error');
			$('.tipsy-inner').css('background-color', '#C00');
			$('.tipsy-arrow').css('border-right-color', '#C00');
			$('.tipsy-arrow').css('border-left-color', '#C00');

			$('[name="Uzytkownik[' + i + '][' + attribute + ']"]').change(function() {
				$('[name="' + $(this).attr("name") + '"]').tipsy('hide');
				/*$(this).removeClass('error');
				$(this).animate({
					borderColor: '#FFF'
				},
				{
					finish: function() {
							$(this).removeClass('error');
						}
				});*/
			});

			//currentInput.parent().find('.errorMessage').text(errors[i][attribute]);
			/**************************/
			// TODO wstawić tipsy zamiast powyższych  /***/ tak jak poniżej:
			// currentInput.tipsy({gravity: 'w', trigger: 'manual', title: function() { return errors[i][attribute]; } }).tipsy("show");
		}
	}

	showRegisterWindow('dialog-register-4-' + firstUserError);
}

function getUsersSummary(userWindowId) {
	var summaryHtml = '';
	var userId = 1;
	var selector = '[id^="dialog-register-4"]';

	if (userWindowId != undefined) {
		selector = '[id^="dialog-register-4"][userWindowId="' + userWindowId + '"]';
		userId = userWindowId;
	}

	$(selector).each(function() {
		var formEmpty = true;
		$(this).find('input[type="text"],input[type="password"]').each(function() {
			if ($(this).val().length > 0)
				formEmpty = false;
		});
		if (!formEmpty) {
			//console.log($(this).find('input[name^="Uzytkownik"]').val());
			summaryHtml += '<table>';
			summaryHtml += '<tr><td colspan="2"><b>Użytkownik nr ' + userId + ':</b></td></tr>';
			console.log('<tr><td colspan="2" style="text-align: right;">\n\
								<input type="button" style="background: url("' + window.baseUrl + '/images/gui/update.png") no-repeat; cursor: pointer; width: 20px; height: 22px;" id="register-back-summary-4-' + userId + '" target="dialog-register-4-' + userId + '" name="back" value="  " />\n\
							</td></tr>');
			if (userWindowId == undefined)
				summaryHtml += '<tr><td colspan="2" style="text-align: right;">\n\
								<input type="button" class="register-edit-user" id="register-back-summary-4-' + userId + '" target="dialog-register-4-' + userId + '" name="back" value="  " />\n\
							</td></tr>';
			summaryHtml += '<tr><td>Imię: </td><td>' + $('input[name="Uzytkownik[' + userId + '][imie]"]').val() + '</td></tr>';
			summaryHtml += '<tr><td>Nazwisko: </td><td>' + $('input[name="Uzytkownik[' + userId + '][nazwisko]"]').val() + '</td></tr>';
			summaryHtml += '<tr><td>E-mail: </td><td>' + $('input[name="Uzytkownik[' + userId + '][email]"]').val() + '</td></tr>';
			summaryHtml += '</table>';
		}
		userId++;
	});
	return summaryHtml;
}

//searchs for last user form window with at least one field not empty, used while going back from last page
function getLastUserView() {
	var lastUserId = 0;
	$('[id^="dialog-register-4"]').each(function() {
		var formEmpty = true;
		$(this).find('input[type="text"],input[type="password"]').each(function() {
			if ($(this).val().length > 0)
				formEmpty = false;
		});
		if (!formEmpty)
			lastUserId++;
		else
			return false;
	});

	return lastUserId;
}

function loadSchools(cityName) {
	console.log(cityName);
	$('.schoolsSelectContainer option').hide();
	$('[data-user-reg-form-school="' + cityName + '"]').show();
	$('.schoolsSelectContainer select').val($('[data-user-reg-form-school="' + cityName + '"]:first').val());
	loadClasses($('.schoolsSelectContainer select').val());
}

function loadClasses(schoolId) {
	$('.classesSelectContainer option').hide();
	$('.UserRegistrationForm_class_' + schoolId).show();
	$('.classesSelectContainer select').val($('.UserRegistrationForm_class_' + schoolId + ':first').val());
}
